/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * berror.h                                                            *
   * Christian Zurhorst, BID R&D, 12. Sep. 1997                          *
   *                                                                     *
   * define error codes                                                  *
   *                                                                     *
   ***********************************************************************
*/

#ifndef __BERROR_H
#define __BERROR_H

#ifndef CLI
#define CLI
#endif



/* IMPORTANT NOTE !!
   Error codes are part of the C-API and therefore part of the user interface.
   Make sure that every new error code is registered and explained in the
   .../Definition/ERS-CAPI/Work/ErrorMessages.htm file. Before inserting new
   codes you should scan the nodes in the table to find the best place where
   to put it or whether it could already be covered by other error messages.

   !! Usage of not documented error codes is forbidden !!
   CZ */


typedef enum {
  B_ERRPAR_1 = 0,
  B_ERRPAR_2,
  B_ERRPAR_3,
  B_ERRPAR_4,
  B_ERRPAR_5,
  B_ERROR_NUMPARAMS	/* for internal use only */
} b_errparamtype;


CLI typedef enum {
  B_E_OK = 0,
  B_EFW_OK = 0,

  /* generic error messages */
  B_E_ERROR,
  B_E_API_ERROR,
  B_E_FUNC,

  /* connecting to the card */
  B_E_NO_HANDLE_LEFT,
  B_E_BAD_HANDLE,
  B_E_NOT_CONNECTED,
  B_E_CANNOT_CONNECT,
  B_E_CANNOT_CONNECT_EXCLUSIVE,
  B_E_CANNOT_CONNECT_CORE,
  B_E_CONNECTION_LOST,
  B_E_CONNECTION_LOST_CMD,                                  /* 10 */
  B_E_UNKNOWN_HARDWARE,
  B_E_VERSION_MISMATCH,

  /* command and data transfer */
  B_E_NOT_E2925A,
  B_E_ONLY_E2925A,
  B_E_ONLY_E2925A_DEEP,
  B_E_EPP_ONLY_E2925A,
  B_E_ONLY_COMPACT,
  B_E_NOT_COMPACT,
  B_E_ONLY_CORE,
  B_E_CORE_ONLY_RS232,
  B_E_CORE_VERSION_MISMATCH,
  B_E_WRONG_PORT,
  B_E_UNTRANSLATED_CMD,
  
  /* range checking and parameters */
  B_E_NO_CAPABILITY, /* There is no hardware capability for this call at all */

  B_E_PARAM,
  
  B_E_VALUE,			/* the following 4 are overloaded by *//*20*/
  B_E_RANGE,			/* dynamic capabilities */
  B_E_ALIGN,
  B_E_PARAM_NOT_EXIST,

  B_E_SYNTAX,
  B_E_FCT_PARAM,

  B_E_UNDERFLOW,		/* these two errors appear whenever */
  B_E_OVERFLOW,			/* a return value is out of range   */

  /* master errors */
  B_E_MASTER_ABORT,
  B_E_SYSMEM_PREPCMD,
  B_E_SYSMEM_DATACOMPARE,
  
  /* decoder errors */
  B_E_CONFIG_VALUE_INVALID,
  B_E_CONFIG_MASK_INVALID,
  
  /* E2925A only errors */
  B_E_JEDEC_UES,

  /* host errors */
  B_E_FILE_OPEN,
  B_E_BAD_FILE_FORMAT,                                     /* 30 */
  B_E_HOST_MEM_FULL,
  
  /* miscellaneous errors */
  B_E_UNKNOWN_ERR,
  B_E_SELFTEST_FAILED,
  
  /* developer's section */
    /* communication */
  B_E_PARTIAL_XMIT,
  B_E_PARTIAL_RCVE,

    /* file access */
  B_E_FILE_ITEM_NOT_FOUND,
  
  B_E_TBD,
  B_E_MAXERR,

  B_E_INTERNAL_RETURN,

  
  /* *******************************************************************
   * Attention!!
   * Do not use any more error codes below this comment
   * *******************************************************************/
  
  /* serial port */
  B_E_RS232_OPEN,                                           /* 40 */
  B_E_BAUDRATE,

  /* parallel port */
  B_E_PARALLEL_OPEN,

  /* PCI port */
  B_E_PCI_OPEN,
  B_E_IO_OPEN,
  B_E_NO_BEST_PCI_DEVICE_FOUND,
  B_E_DRIVER_VERSION_DIFF,
  B_E_PCI_NT_ONLY,              /* Attempt PCI open under non-WinNT */

  /* fast HIF port */
  B_E_HIF_OPEN,
  B_E_HIF_WIN32_ONLY,           /* Attempt HIF open under non-Win32 */

  /* simulation port */

  /* generic I/O ... any and all ports */
  B_E_GRANULARITY,                                         /* 50 */
  B_E_GRANULARITY_BEST,
  B_E_GRANULARITY_GT_PORT_MAX,
  B_E_SETTING_TIMEOUTS,         /* Error setting timeouts */
  
  /* master related errors */
  B_E_MBLOCKCMD_DAC,

  /* decoder related errors */
  B_E_NO_PCI_CLOCK,
  B_E_BAD_DECODER_NUMBER,

  B_E_CPU_MISALIGNED,

  B_E_WRONG_PARAMETER,
  B_E_CONF_REG,
  B_E_MASK_REG,
  B_E_DEC_CHECK,                                            /* 60 */
  B_E_PROG_DEC_ENABLE,
  B_E_WRONG_PROP,
  B_E_TEST_NO_DECODER,
  B_E_INVALID_OBS_RULE,
  B_E_INVALID_TC_SIG,
  B_E_NO_DWORD_BOUNDARY,
  B_E_NO_WORD_BOUNDARY,
  B_E_DEC_SIZE_BASE_MISMATCH,
  B_E_DEC_INVALID_SIZE,
  B_E_DEC_INVALID_MODE,
  B_E_DEC_INVALID_DECODER,
  B_E_DEC_CONFIG_ACCESS,
  B_E_HW_BUSY,
  B_E_DEC_BASE_WRITE,
  B_E_DEC_BASE_NOT_0,
  B_E_BOARD_RESET,
  B_E_DEC_ROM_SIZE_0_ENABLED,
  B_E_SST_ABORTED,
  B_E_SST_STOPPED,
  B_E_SST_SETUP_ERROR,
  B_E_SST_PAUSED,
  B_E_SST_EVENTERROR,
  B_E_SST_REPORTERROR,
  B_E_SST_RESET,		/* reset has occured during test run */
  B_E_SST_INTROPEN,
  B_E_SST_INTRSETUP,
  B_E_SST_INTRCONNECT,
  B_E_SST_INTRERROR,
  B_E_PPR_LIST_EMPTY,
  B_E_PPR_LIST_FULL,
  B_E_PPR_OUT_OF_RANGE,
  B_E_PPR_CALL_INIT,
  B_E_PPR_PAGESIZE_EXCEED,
  B_E_PPR_FIRST_TOO_LARGE,
  B_E_PPR_64BIT_RESTRICTION,
  B_E_WRONG_HW,
  B_E_ROM_ENABLED,
  B_E_ROM_INTERNAL,
  B_E_PERFBOARD_ERROR,          /* ** Missing error message ** */
  B_E_WRONG_BUSADDR,
  B_E_REG_VALUE_NOT_DWORD,      /* Returned from routines in pci32reg.c */
  B_E_REG_VALUE_NOT_SZ,         /*  " */
  B_E_REG_VALUE_NOT_GET,        /*  " */
  B_E_REG_VALUE_NOT_SET,        /*  " */
  B_E_REG_KEY_NOT_OPEN,         /*  " */
  B_E_REG_OWNER_NONE,           /*  " */
  B_E_REG_OWNER_IS_OTHER,       /*  " */
  B_E_REG_NULL_PTR_PARAM,       /*  " */
  B_E_CONFIG_READ_BAD,


  B_E_DYNAMIC_CAPABILITY,     /* An Error concering the dynamic capabilities*/
  B_E_PARAM_OUT_OF_RANGE,       /* A Parameter is out of range */
  B_E_PARAM_NULL_POINTER,       /* NULL-pointer passed as argument */

  /* other errors */
  B_E_NOT_IMPLEMENTED,          /* function not implemented for this protocol */

  B_E_COUNT,
  
  B_E_FIRMWARE = 10000,		/* internal delimiter */
  
  /* generic error messages */
  B_EFW_ERROR,
  B_EFW_FUNC,

  /* command and data transfer */
  B_EFW_DATA_CHECKSUM,
  B_EFW_CMDLOCKED,
  B_EFW_NO_CAPABILITY,
  
  /* range checking and parameters */
  B_EFW_PARAM,
  
  B_EFW_VALUE,			/* the following 4 are overloaded by */
  B_EFW_RANGE,			/* dynamic capabilities */
  B_EFW_ALIGN,
  B_EFW_PARAM_NOT_EXIST,


  /* timing checker range checking */
  B_EFW_TIMCHECK_RANGE,
  B_EFW_TIMCHECK_SETUP,
  B_EFW_TIMCHECK_HOLD,

  B_EFW_SYNTAX,

  /* attribute and block pages */
  B_EFW_PAGE_CONCATENATED,
  B_EFW_PAGE_EMPTY,
  B_EFW_PAGE_FULL,
  B_EFW_ILLEGAL_PAGE_OFFSET,
  B_EFW_ATTR_PROGMODE_MIXED,
  B_EFW_BADIAD_MISMATCH,
  
  /* master errors */
  B_EFW_MEN_NOT_SET,
  B_EFW_MBLOCKCMD_DAC,
  B_EFW_MASTER_WARN64BIT, 
  B_EFW_MASTER_64BIT_RESTRICTION,
  
  /* decoder errors */
  B_EFW_DECODER_NO_DAC,
  B_EFW_DECODER_GRABBED,
  B_EFW_FASTDECODER_GRABBED,
  B_EFW_BASEDEC_NOT_NORMAL,
  B_EFW_OVERLAY_RANGE_SUBSET,
  B_EFW_OVERLAY_CMD_SUBSET,
  B_EFW_CONFIG_CMD_SUBSET,
  B_EFW_FASTDECODER_COMMAND_ERROR,

  /* pattern parser errors */
  B_EFW_PATT_SYNTAX,
  B_EFW_PATT_UNDEF_TOKEN,
  B_EFW_PATT_MTO_LISTSIGNAL,
  B_EFW_PATT_UNKNOWN_ERR,

  /* Deep Trace Memory errors */
  B_EFW_DEEPTRACE_FUNC,
  
  /* environment related errors */
  B_EFW_CALIBRATION,	        /* no or wrong calibration version */
  B_EFW_PCICLK_TOO_SLOW,	/* pciclk too slow or not running  */
  B_EFW_PCICLK_TOO_FAST,	/* pciclk too fast                 */
  B_EFW_PCI_NOPOWER,		/* power good not signaled */
  B_EFW_EX_INIMODESET_FAILED,	/* programming failed, because ... */
  B_EFW_AN_INIMODESET_FAILED,	/* programming failed, because ... */
  B_EFW_TARGET_BUSY,		/* target still active, deactivate target (force retry) */
  B_EFW_TARGET_DISABLED,
  
  /* miscellaneous errors */
  B_EFW_ICHIBANTEST_FAILED,
  B_EFW_IMAGE_TOO_LARGE,
  B_EFW_LIFELOCK_PREVENTION,
  B_EFW_CARD_MEM_FULL,
  
  /* developers' errors */
  B_EFW_TBD,                	/* to be done */
  B_EFW_MAXERR,
  
  B_EFW_UNKNOWNCMD,          	/* cmd not leading to a valid entry (2) */
  
  /* *******************************************************************
   * Attention!!
   * Do not use any more error codes below this comment
   * *******************************************************************/
  

  B_EFW_INVALID_KEY,		/* a key (e.g. license) was invalid (0) */

  /* parameter passing */
  B_EFW_OUTOFRANGE,		/* some parameter was out of range (3) */
  
  /* register file */
  B_EFW_WRONGPORT,		/* a request was issued from a wrong port */
  				/* (3) */

  /* ROM management */
  B_EFW_DBRESETTED,		/* due unrecoverable errors the edit set */
  				/* database got resetted (0) */
  B_EFW_EXPROM_FAILED,		/* access to expansion ROM failed */
  
  /* sequencer errors (common to all sequencer)                           */
  B_EFW_SEQ_SYNTAX_ERR,		/* sequencer syntax error          */
  B_EFW_SEQ_TOO_MANY_STATES,	/* too many states for this sequencer */
  B_EFW_SEQ_TOO_MANY_INPUTS,	/* too many inputs for this sequencer */
  B_EFW_SEQ_UNKNOWN_TOKEN,	/* don't know this token */
  B_EFW_SEQ_UNKNOWN_OUTPUT,	/* don't know this output */
  B_EFW_SEQ_TRAN_EXCLUSIVE,	/* transitions leaving a state not exclusive */
  B_EFW_SEQ_BUNDLE_SIGNAL,	/* cannot set output to this value */
  
  /* UNIX debug session */
  B_EFW_EOF,			/* unexpected end of file */
  B_EFW_FWRITE,			/* error during file write operation */
  B_EFW_FREAD,			/* error during file read operation */

  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* -------- BLOCK AND ATTRIBUTE MEMORY ------------------------------ */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  B_EFW_NO_EOP_FOUND,
  B_EFW_INVALID_ATTRPOINTER,
  B_EFW_INVALID_PREP_ATTRPOINTER,

  B_EFW_COUNT,

  B_EFW_CORE_UPDATED = 10254,
  B_EFW_LONG_OPERATION = 10255,
  
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* --------some internal error messages - always at the end---------- */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  B_EFW_INTERNAL_RETURN,
  B_EFW_CMDFOUND
  
  /* -------- do NOT put anything after this line !!!! ----------- */  
} b_errtype;



/* range groups */

/* NOTE: keep entries aligned with pcst_list array in error.c !! */
typedef enum {
  B_PCST_UNKNOWN,		/* has to be the first */

  /* TODO: throw out all the generic stuff, that's not the purpose of this */
  B_PCST_MATTR_PAGE,
  B_PCST_TATTR_PAGE,
  B_PCST_TRIGGER_CTR,
  B_PCST_MBLOCK_PAGE,
  B_PCST_OFFSET,
  B_PCST_VALUE,
  B_PCST_GROUP,
  B_PCST_CONFIG_REG,
  B_PCST_NUMBEROFBYTES,
  B_PCST_DMEM_ADDR,

  B_PCST_TRCMEM_NOL,
  B_PCST_TRCMEM_NOB,
  B_PCST_TRCMEM_OFFSET,
  
  B_PCST_ADDRESS,
  B_PCST_SIZE,
  B_PCST_DEVICE,

  B_PCST_PPR_BPP,		/* ppr block permutation property */
  B_PCST_PPR_APP,		/* ppr attr permutation property */
  B_PCST_PPR_GEN,		/* ppr generic property */
  B_PCST_PPR_REP,		/* ppr generic property */

  B_PCST_LAST			/* has to be the last */
} b_paramcustom;


typedef enum {
  B_GENCMD_IO_READ,
  B_GENCMD_IO_WRITE,
  B_GENCMD_MEM_READ,
  B_GENCMD_MEM_WRITE,
  B_GENCMD_CONFIG_READ,
  B_GENCMD_CONFIG_WRITE
} b_gencommandtype;


typedef enum {
  B_PGMEM_BLOCK,
  B_PGMEM_MATTR,
  B_PGMEM_TATTR
} b_pagememtype;


typedef enum {
  B_VERCHK_FIRMWARE
} b_versioncheck;


typedef enum {
  B_EERR_UNKNOWN,
  B_EERR_READ_WRITE,	/* ReadFile/WriteFile returned with error */
  B_EERR_GENERIC_READ,	/* generic on read error */
  B_EERR_GENERIC_WRITE,	/* generic on write error */
  B_EERR_DRV_FAILURE,	/* a driver returned no success */
  B_EERR_DRV_TIMEOUT,	/* timeout detected by driver */
  B_EERR_CAPI_TIMEOUT,	/* timeout detected by CAPI */
  B_EERR_PARTIAL_RCVE,	/* partial receive error detected in io32.c */
  B_EERR_UNKNOWN_REPLY	/* the E2925A returned an unknown reply byte */
} b_e_error_type;


/* obsolete !! */
enum {
  B_ERG_ANY,
  
  B_ERG_EXERCISER,
  
  B_ERG_MASTER,
  B_ERG_TARGET,
  B_ERG_TDEC,
  B_ERG_TDECPROP,
  B_ERG_CONFIG,
  
  B_ERG_ANALYZER,

  B_ERG_CPUPORT,
  B_ERG_CPPROP
};


/* error group config members */

/* obsolete !! */
enum {
  B_ERG_CONFIG_OFFSET,
  B_ERG_CONFIG_VALUE,
  B_ERG_CONFIG_MASK
};


#endif
